package gov.va.med.mhv.usermgmt.service;

import java.util.GregorianCalendar;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPv3;


public class NetscapeLdapTest {
	public static void main(String[] args){					
		try {						
			String searchFilter = "(&(objectClass=user)(sn=s*))";    //last name search
			//String searchFilter = "(&(objectClass=user)(cn=Shrader, Jon))"; //full name search
			//String searchFilter = "(&(objectClass=user)(sAMAccountName=VHAISASHRADJ))"; //vhaid search
			
			LDAPConnection conn = new LDAPConnection();
			LDAPSearchConstraints constraints = new LDAPSearchConstraints();
			conn.connect("vhaish3dc2.vha.domain.ext", 3268, "vhamaster\\vhaishmhvsa","!!MyHealth00");
			constraints.setMaxResults(0);
			constraints.setServerTimeLimit(0);
			constraints.setTimeLimit(0);
			constraints.setReferrals(false);
			
			//initialize counter to total the results
			int totalResults = 0; 
 
			//Search for objects in the GC using the filter
			GregorianCalendar startSearch = new GregorianCalendar();
			
			LDAPSearchResults results = conn.search(
					"DC=va,DC=gov", LDAPv3.SCOPE_SUB, searchFilter, new String[]{"sAMAccountName","name","givenName","title","telephoneNumber","l","physicalDeliveryOfficeName","sn"}, false,constraints);
						
			GregorianCalendar endSearch = new GregorianCalendar();
			System.out.println("Search Complete, Total Search Time: " + TimingHelper.calcDuration(startSearch,endSearch));

			//Loop through the search results
			GregorianCalendar startProcessing = new GregorianCalendar();
			while (results.hasMoreElements()) {
				results.next(); 
				totalResults++;
			}
			conn.disconnect();	
			GregorianCalendar endProcessing = new GregorianCalendar();
			
			System.out.println("Processing Complete, Total Processing Time: " + TimingHelper.calcDuration(startProcessing,endProcessing));
			System.out.println(totalResults + " were found and processed, " + "Total Time: " + TimingHelper.calcDuration(startSearch,endProcessing));
			System.out.println("All Done, Leaving Search At: " + new GregorianCalendar().getTime());
		} 
		catch (LDAPException e) {
			System.err.println("Problem searching directory: " + e);
		}		  
	}
}
